//=============================================================================
// FontEdgeColorEscapeCode.js
// ----------------------------------------------------------------------------
// (C)2022 kuroame koubou
// This software is released under the MIT License.
// http://opensource.org/licenses/mit-license.php
// ----------------------------------------------------------------------------
// Version
// 0.9.0 2023/06/22 初版
// ----------------------------------------------------------------------------
// [Blog]   : http://kuroamekoubou.blog.fc2.com
// [Twitter]: https://twitter.com/kuroVelter9623
//=============================================================================

/*:
 * @plugindesc 文字縁取り色変更制御文字
 * @target MZ
 * @author くろあめ
 *
 * @help
 * 制御文字が使用可能なすべてのウィンドウで使える
 * 文字の縁取り色を変える制御文字を追加します。
 * 
 * \B[（カラーID）]　と記載することで、文字の縁取り色を指定したカラーIDのものに変更します
 * \D　と記載することで、文字の縁取り色をデフォルトの黒に戻します。
 *
 * ツクールのエディタ上のメッセージプレビューでは動作しませんので、ご注意ください。
 *
 * 利用形態（商用、18禁利用等）について制限はありません
 * 作者への使用報告や、ReadMeなどへ作者・サイト名の記載も任意となります。
 *
 * ただし、作者はこれらのプラグインについて
 * 基本的に一切のサポートを行いません
 * 何か問題が起きた時、ご自身で解決できる方のみご利用ください。
 */

(function() {

const _Window_Base_processEscapeCharacter_kuro = Window_Base.prototype.processEscapeCharacter;
Window_Base.prototype.processEscapeCharacter = function(code, textState) {
    _Window_Base_processEscapeCharacter_kuro.apply(this, arguments);
    switch (code) {
        case "B":
            this.changeOutlineColor_B(this.obtainEscapeParam(textState));
            break;
        case "D":
            this.changeOutlineColor_D();
            break;
    }
};

Window_Base.prototype.changeOutlineColor_B = function(colorIndex) {
    let setColor = ColorManager.textColor(colorIndex);
    this.contents.outlineColor = setColor;
    
};

Window_Base.prototype.changeOutlineColor_D = function() {
    this.contents.outlineColor = "rgba(0, 0, 0, 0.5)";
};


})();
